<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$logFile = __DIR__ . "/../otp_debug.log";

// Detect calling service automatically
$callingService = "unknown";

// Lambda
if (getenv('AWS_LAMBDA_FUNCTION_NAME')) {
    $callingService = "Lambda";
}
// EC2 (check metadata endpoint)
elseif (@file_get_contents(
    'http://169.254.169.254/latest/meta-data/instance-id',
    false,
    stream_context_create(['http' => ['timeout' => 0.1]])
)) {
    $callingService = "EC2";
}
// Cognito
elseif (!empty($_SERVER['HTTP_X_AMZ_COGNITO_IDENTITY'])) {
    $callingService = "Cognito";
}

// Detect which script/API triggered this request
// Optionally, you can send a custom header "X-Calling-Script" from caller
$callingScript = $_SERVER['HTTP_X_CALLING_SCRIPT'] 
    ?? ($_SERVER['SCRIPT_FILENAME'] ?? 'unknown');

// Build log entry
$logEntry = [
    "timestamp"       => date("Y-m-d H:i:s"),
    "full_path"       => realpath(__FILE__),                        // Current script full path
    "source_ip"       => $_SERVER['REMOTE_ADDR'] ?? 'unknown',
    "forwarded_for"   => $_SERVER['HTTP_X_FORWARDED_FOR'] ?? 'none', // Real client if behind LB
    "referer"         => $_SERVER['HTTP_REFERER'] ?? 'none',         // Caller page/script
    "user_agent"      => $_SERVER['HTTP_USER_AGENT'] ?? 'none',
    "request_method"  => $_SERVER['REQUEST_METHOD'] ?? 'none',
    "query_string"    => $_SERVER['QUERY_STRING'] ?? 'none',
    "post_data"       => $_POST ?: [],
    "calling_service" => $callingService,
    "calling_script"  => $callingScript
];

// Append log as JSON line
file_put_contents($logFile, json_encode($logEntry) . PHP_EOL, FILE_APPEND);

require_once __DIR__ . '/../aws_get_env.php'; // fetch AWS keys dynamically
require __DIR__ . '/../vendor/autoload.php';

use Aws\Sns\SnsClient;
use Aws\Exception\AwsException;

// Input
$phoneNumber = $_POST["phoneNumber"] ?? null;
$message1    = $_POST["message"] ?? null;

if (!$phoneNumber || !$message1) {
    echo json_encode([
        "status" => "failed",
        "error"  => "phoneNumber or message missing"
    ]);
    exit;
}

// Fetch AWS credentials dynamically
$awsAccessKey = get_aws_secret("AWS-ACCESS-KEY");
$awsSecretKey = get_aws_secret("AWS-SECRET-KEY");

// SNS Client
$params = [
    'credentials' => [
        'key'    => $awsAccessKey,
        'secret' => $awsSecretKey
    ],
    'region'  => 'ap-south-1',
    'version' => 'latest'
];

$sns = new SnsClient($params);

$args = [
    'Message'     => $message1,
    'PhoneNumber' => $phoneNumber
];

try {
    $result = $sns->publish($args);
    echo json_encode([
        "status" => "success",
        "result" => $result
    ]);
} catch (AwsException $e) {
    error_log($e->getMessage());
    echo json_encode([
        "status" => "failed",
        "error"  => $e->getAwsErrorMessage()
    ]);
}
?>
