<?php

/**
 * Copyright 2010-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * This file is licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License. A copy of
 * the License is located at
 *
 * http://aws.amazon.com/apache2.0/
 *
 * This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 *  ABOUT THIS PHP SAMPLE: This sample is part of the SDK for PHP Developer Guide topic
 *
 *
 */
require 'vendor/autoload.php';

use Aws\Sns\SnsClient; 
use Aws\Exception\AwsException;

/**
 * Sends a a text message (SMS message) directly to a phone number using Amazon SNS.
 *
 * This code expects that you have AWS credentials set up per:
 * https://docs.aws.amazon.com/sdk-for-php/v3/developer-guide/guide_credentials.html
 */
 
 $phonenumber  = $_POST["username"];
 $otp  = $_POST["iveposOtp"];


$params = array(
    'credentials' => array(
        'key' => getenv('AWS_ACCESS_KEY_ID') ?: 'AKIAQ3XWIYFD5UXDLO56', // Use environment variables
        'secret' => getenv('AWS_SECRET_ACCESS_KEY') ?: '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' // Use environment variables
    ),
    'region' => 'ap-south-1',
    'version' => 'latest'
);

$sns = new Aws\Sns\SnsClient($params);

//$message = 'Thank you for your '.$otp.' purchase of '.$otp.' '.$otp.' /- on bill '.$otp.' from '.$otp.'. Please come again. Regards Intuition.';

$message = 'Your IVEPOS/Intuition OTP for secure login is : '.$otp.'';

$args = array(
            'Message' => $message,
            'PhoneNumber' =>  $phonenumber,
            
);

// 'EntityId' => '1101689470000044469',
            // 'TemplateId' => '1107166185184245258',


try {

 $blockedCodes = ['+880', '+964', '+20','+93'];

    if (isBlockedNumber($phonenumber, $blockedCodes)) {
    
}else {

    $result = $sns->publish($args);
   
    //$myJSON = json_encode($result);
	$myObj1= new \stdClass();
$myObj1->status ="success";
$myObj1->message= $result;
$myJSON = json_encode($myObj1); 
echo $myJSON;	
}

} catch (AwsException $e) {
    // output error message if fails
    error_log($e->getMessage());
	$myObj1= new \stdClass();
$myObj1->status ="failed";
$myObj1->message= $e->getMessage();
$myJSON = json_encode($myObj1); 
echo $myJSON;
   
} 

// Function to check if phone number starts with any blocked code
function isBlockedNumber($phonenumber, $blockedCodes) {
    foreach ($blockedCodes as $code) {
        if (strpos($phonenumber, $code) === 0) {
            return true;
        }
    }
    return false;
}

?>