<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

$servername = "ivepos-db-production.mysql.database.azure.com";
$username   = "iveposadmin";
$password   = "Intuition123";

ini_set('max_execution_time', 2400);

$post = json_decode(file_get_contents('php://input'));

$company = $post->company ?? "";
$store   = $post->store ?? "";
$device  = $post->device ?? "";
$data    = $post->data ?? [];
$table   = $post->table ?? "";

$dbname = $company . "_" . $store . "_" . $device . "_" . "mydbappdata";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die(json_encode([
        "status"  => "error",
        "message" => "DB Connection failed: " . $conn->connect_error
    ], JSON_PRETTY_PRINT));
}

// ----------- TABLE RESET HANDLING (items, hotel1, hotel, taxes) --------------
function resetTableAndPush($table, $company, $store, $device, $deleteQuery, $resetSeqQuery) {
    require_once __DIR__ . '/firebase/firebase.php';
    require_once __DIR__ . '/firebase/push.php';

    $firebase = new Firebase();
    $push     = new Push();

    $resultLog = [];

    // Send delete message
    $push->setMessage($deleteQuery);

    $servername1 = "ivepos-db-production.mysql.database.azure.com";
    $username1   = "iveposadmin";
    $password1   = "Intuition123";
    $dbname1     = "ivepos_license_retail";

    $conn1 = new mysqli($servername1, $username1, $password1, $dbname1);
    if ($conn1->connect_error) {
        $resultLog[] = "Reset DB Connection failed: " . $conn1->connect_error;
        return $resultLog;
    }

    // Fetch company
    $companyid = 0;
    $sql = "SELECT * FROM company WHERE company='" . $company . "'";
    $result = $conn1->query($sql);
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $companyid = $row["id"];
        }
    }

    // Fetch store
    $storeid = 0;
    $sql = "SELECT * FROM store WHERE companyid='" . $companyid . "' AND store ='" . $store . "'";
    $result = $conn1->query($sql);
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $storeid = $row["id"];
        }
    }

    // Fetch device and send firebase message
    $sql = "SELECT * FROM device WHERE storeid='" . $storeid . "' AND companyid='" . $companyid . "' AND device='" . $device . "'";
    $result = $conn1->query($sql);
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $regId = $row["regid"];
            if ($regId != null) {
                $json = $push->getPush();
                $firebase->send($regId, $json);
                $resultLog[] = "Push sent (delete) to device: " . $device;
            }
        }
    }

    // Reset sqlite_sequence
    $push->setMessage($resetSeqQuery);
    $result = $conn1->query("SELECT * FROM device WHERE storeid='" . $storeid . "' AND companyid='" . $companyid . "' AND device='" . $device . "'");
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $regId = $row["regid"];
            if ($regId != null) {
                $json = $push->getPush();
                $firebase->send($regId, $json);
                $resultLog[] = "Push sent (reset seq) to device: " . $device;
            }
        }
    }

    return $resultLog;
}

// handle different table resets
$resetLogs = [];
if ($table === "items") {
    $resetLogs = resetTableAndPush("items", $company, $store, $device, "delete from items", "UPDATE sqlite_sequence SET seq = 0 WHERE NAME = 'items'");
}
if ($table === "hotel1") {
    $resetLogs = resetTableAndPush("hotel1", $company, $store, $device, "delete from hotel1", "UPDATE sqlite_sequence SET seq = 0 WHERE NAME = 'hotel1'");
}
if ($table === "hotel") {
    $resetLogs = resetTableAndPush("hotel", $company, $store, $device, "delete from hotel", "UPDATE sqlite_sequence SET seq = 0 WHERE NAME = 'hotel'");
}
if ($table === "taxes") {
    $resetLogs = resetTableAndPush("taxes", $company, $store, $device, "delete from taxes", "UPDATE sqlite_sequence SET seq = 0 WHERE NAME = 'taxes'");
}

// ------------------- DATA INSERTION -------------------------
$result = TRUE;
$executedQueries = [];

foreach ($data as $jsons) {
    set_time_limit(2400);
    $query = "INSERT INTO ";
    $query1 = "(";
    $query2 = "(";

    foreach ($jsons as $key => $value) {
        if ($key === "table") {
            $table = $value;
        } else {
            $query1 .= $key . ",";
            $query2 .= "'" . $conn->real_escape_string($value) . "',";
        }
    }

    $query1 = rtrim($query1, ", ");
    $query2 = rtrim($query2, ", ");
    $query .= $table . $query1 . ") VALUES " . $query2 . ")";

    if ($conn->query($query) === TRUE) {
        $executedQueries[] = "SUCCESS: " . $query;
    } else {
        $result = FALSE;
        $executedQueries[] = "ERROR: " . $query . " -> " . $conn->error;
    }
}

// ------------------- PUSH CSV UPLOAD MESSAGE -------------------------
require_once __DIR__ . '/firebase/firebase.php';
require_once __DIR__ . '/firebase/pushcsv.php';

$firebase = new Firebase();
$push     = new Pushcsv();

$push->setMessage("csv upload");

$servername1 = "ivepos-db-production.mysql.database.azure.com";
$username1   = "iveposadmin";
$password1   = "Intuition123";
$dbname1     = "ivepos_license_retail";

$conn1 = new mysqli($servername1, $username1, $password1, $dbname1);
$csvPushLogs = [];
if (!$conn1->connect_error) {
    $sql = "SELECT * FROM company WHERE company='" . $company . "'";
    $result1 = $conn1->query($sql);
    $companyid = 0;
    if ($result1 && $result1->num_rows > 0) {
        while ($row = $result1->fetch_assoc()) {
            $companyid = $row["id"];
        }
    }

    $sql = "SELECT * FROM store WHERE companyid='" . $companyid . "' AND store ='" . $store . "'";
    $result1 = $conn1->query($sql);
    $storeid = 0;
    if ($result1 && $result1->num_rows > 0) {
        while ($row = $result1->fetch_assoc()) {
            $storeid = $row["id"];
        }
    }

    $sql = "SELECT * FROM device WHERE storeid='" . $storeid . "' AND companyid='" . $companyid . "' AND device='" . $device . "'";
    $result1 = $conn1->query($sql);
    if ($result1 && $result1->num_rows > 0) {
        while ($row = $result1->fetch_assoc()) {
            $regId = $row["regid"];
            if ($regId != null) {
                $json = $push->getPushCSV();
                $firebase->send($regId, $json);
                $csvPushLogs[] = "CSV push sent to device: " . $device;
            }
        }
    }
}

// ------------------- FINAL RESPONSE -------------------------
if ($result === TRUE) {
    $arr = [
        'status'   => "success",
        'resetLog' => $resetLogs,
        'queries'  => $executedQueries,
        'csvPush'  => $csvPushLogs
    ];
} else {
    $arr = [
        'status'   => "error",
        'resetLog' => $resetLogs,
        'queries'  => $executedQueries,
        'csvPush'  => $csvPushLogs
    ];
}

$response = json_encode($arr, JSON_PRETTY_PRINT);
echo $response;
