<?php

// ========== Helper Function ==========
function getStoreSalesSum($conn) {
    $sql = "
        SELECT 
            SUM(total) AS total_sum,
            SUM(CASE WHEN (vendor_payment_status IS NULL OR vendor_payment_status = '' OR vendor_payment_status <> 'success') 
                     THEN purchase_price_total ELSE 0 END) AS ppt_sum,
            SUM(CASE WHEN (profit_payment_status IS NULL OR profit_payment_status = '' OR profit_payment_status <> 'success') 
                     THEN profit ELSE 0 END) AS profit_sum
        FROM All_Sales
        WHERE vendor_name != ''
    ";

    $result = $conn->query($sql);

    if ($result && $row = $result->fetch_assoc()) {
        return [
            'total' => (float) ($row['total_sum'] ?? 0),
            'purchase_price_total' => (float) ($row['ppt_sum'] ?? 0),
            'profit' => (float) ($row['profit_sum'] ?? 0)
        ];
    }

    return ['total' => 0, 'purchase_price_total' => 0, 'profit' => 0];
}

// ========== Main Logic ==========

$servername = "ivepos-db-production.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$licenseDB = "ivepos_license_retail";

$mainConn = new mysqli($servername, $username, $password, $licenseDB);
if ($mainConn->connect_error) {
    echo json_encode(['status' => 'failed', 'message' => 'Main DB connection failed']);
    exit;
}

$storeSummary = [];

$company_id_req = $_POST['company_id'];

$sql = "SELECT * FROM company WHERE id = '$company_id_req'";
$result = $mainConn->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $companyid = $row["id"];
        $company   = strtolower($row["company"]);

        $sql1 = "SELECT * FROM store WHERE companyid = '" . $mainConn->real_escape_string($companyid) . "'";
        $result1 = $mainConn->query($sql1);

        if ($result1 && $result1->num_rows > 0) {
            while ($row1 = $result1->fetch_assoc()) {

                $storeid = $row1["id"];
                $store   = strtolower($row1["store"]);

                $grandTotal = 0;
                $grandPPT   = 0;
                $grandPFT   = 0;

                $sql2 = "SELECT * FROM device WHERE storeid = '".$mainConn->real_escape_string($storeid)."'";
                $result2 = $mainConn->query($sql2);

                if ($result2 && $result2->num_rows > 0) {
                    while ($row2 = $result2->fetch_assoc()) {
                        $device = strtolower($row2["device"]);
                        $dbname = preg_replace('/[^a-z0-9_]/', '', $company . "_" . $store . "_" . $device . "_mydbsalesdata");

                        $conn = new mysqli($servername, $username, $password, $dbname);
                        if ($conn->connect_error) continue;

                        $sums = getStoreSalesSum($conn);
                        $grandTotal += $sums['total'];
                        $grandPPT   += $sums['purchase_price_total'];
                        $grandPFT   += $sums['profit'];

                        $conn->close();
                    }
                }

                $storeSummary[] = [
                    'store_id' => $storeid,
                    'store'    => $store,
                    'total'    => $grandTotal,
                    'purchase_price_total' => $grandPPT,
                    'profit'   => $grandPFT
                ];
            }
        }
    }
}

$mainConn->close();

// Return JSON response
echo json_encode($storeSummary, JSON_PRETTY_PRINT);
?>
