<?php
header('Content-Type: application/json');

$servername = "ivepos-db-production.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$licenseDB = "ivepos_license_retail";

$mainConn = new mysqli($servername, $username, $password, $licenseDB);
if ($mainConn->connect_error) {
    echo json_encode(['status' => 'failed', 'message' => 'Main DB connection failed']);
    exit;
}

// Optional: Filter by company/store if provided
$company = isset($_POST['company']) ? $_POST['company'] : null;
$store   = isset($_POST['store']) ? $_POST['store'] : null;

// Pattern: <company>_<store>_<device>_mydbsalesdata
$pattern = $mainConn->real_escape_string("{$company}_{$store}_%_mydbsalesdata");

$stmt = $mainConn->prepare("SELECT SCHEMA_NAME FROM information_schema.SCHEMATA WHERE SCHEMA_NAME LIKE ?");
$stmt->bind_param("s", $pattern);
$stmt->execute();
$stmt->bind_result($dbName);

$vendorSummary = [];

while ($stmt->fetch()) {
    $conn = new mysqli($servername, $username, $password, $dbName);
    if ($conn->connect_error) continue;

    $sql = "SELECT vendor_name, vendor_id,
                   SUM(total) AS total,
                   SUM(purchase_price_total) AS purchase_price_total,
                   SUM(profit) AS profit
            FROM All_Sales
            WHERE vendor_name != '' 
            GROUP BY vendor_name, vendor_id";

    $result = $conn->query($sql);
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $key = $row['vendor_id'];

            if (!isset($vendorSummary[$key])) {
                $vendorSummary[$key] = [
                    'vendor_name' => $row['vendor_name'],
                    'vendor_id' => $row['vendor_id'],
                    'total' => (float)$row['total'],
                    'purchase_price_total' => (float)$row['purchase_price_total'],
                    'profit' => (float)$row['profit']
                ];
            } else {
                // Aggregate across multiple databases
                $vendorSummary[$key]['total'] += (float)$row['total'];
                $vendorSummary[$key]['purchase_price_total'] += (float)$row['purchase_price_total'];
                $vendorSummary[$key]['profit'] += (float)$row['profit'];
            }
        }
    }

    $conn->close();
}

$stmt->close();
$mainConn->close();

echo json_encode(array_values($vendorSummary));
