<?php
header('Content-Type: application/json');

$servername = "ivepos-db-production.mysql.database.azure.com";
$username   = "iveposadmin";
$password   = "Intuition123";

// Read JSON request body
$data = json_decode(file_get_contents("php://input"), true);

if (
    !$data ||
    !isset($data['databases']) ||
    !isset($data['status']) ||
    !isset($data['transaction_id']) ||
    !isset($data['vendor_code']) ||
    !isset($data['payment_type'])
) {
    echo json_encode(['status' => 'failed', 'message' => 'Invalid request']);
    exit;
}

$status         = $data['status'];
$transaction_id = $data['transaction_id'];
$vendor_code    = $data['vendor_code'];
$payment_type   = strtolower($data['payment_type']); // normalize case

$response = [
    'status'  => 'success',
    'updated' => []
];

foreach ($data['databases'] as $dbName => $dbData) {
    if (!isset($dbData['bill_nos']) || !is_array($dbData['bill_nos'])) {
        $response['updated'][$dbName] = ['error' => 'No bill_nos provided'];
        continue;
    }

    // Connect to the target DB
    $conn = new mysqli($servername, $username, $password, $dbName);
    if ($conn->connect_error) {
        $response['updated'][$dbName] = ['error' => 'DB connection failed'];
        continue;
    }

    // Build placeholders (?, ?, ?, ...)
    $placeholders = implode(',', array_fill(0, count($dbData['bill_nos']), '?'));

    // Decide which extra column to update
    if ($payment_type === "vendor") {
        $extraColumn = "vendor_payment_status = ?";
    } elseif ($payment_type === "profit") {
        $extraColumn = "profit_payment_status = ?";
    } else {
        $response['updated'][$dbName] = ['error' => 'Invalid payment_type'];
        $conn->close();
        continue;
    }

    // SQL Update with vendor_id filter and conditional column
    $sql = "UPDATE All_Sales 
            SET status = ?, transaction_id = ?, $extraColumn
            WHERE bill_no IN ($placeholders) AND vendor_id = ?";

    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        $response['updated'][$dbName] = ['error' => 'Prepare failed'];
        $conn->close();
        continue;
    }

    // Bind parameters (status, transaction_id, extraColumn, bill_nos..., vendor_code)
    $types = "sss" . str_repeat('s', count($dbData['bill_nos'])) . "s";
    $params = array_merge([$types, $status, $transaction_id, $status], $dbData['bill_nos'], [$vendor_code]);

    // Use unpacking for bind_param
    $stmt->bind_param(...$params);

    if ($stmt->execute()) {
        $response['updated'][$dbName] = [
            'status'        => 'success',
            'rows_affected' => $stmt->affected_rows
        ];
    } else {
        $response['updated'][$dbName] = ['error' => $stmt->error];
    }

    $stmt->close();
    $conn->close();
}

echo json_encode($response);
