<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require './vendor/autoload.php';

// ================== Helper Function ==================
function getSalesSum($conn, $vendor_name, $vendor_id) {
    $sql = "
        SELECT 
            SUM(total) AS total_sum,
            SUM(CASE WHEN (vendor_payment_status IS NULL OR vendor_payment_status = '' OR vendor_payment_status <> 'success') 
                     THEN purchase_price_total ELSE 0 END) AS ppt_sum,
            SUM(CASE WHEN (profit_payment_status IS NULL OR profit_payment_status = '' OR profit_payment_status <> 'success') 
                     THEN profit ELSE 0 END) AS profit_sum
        FROM All_Sales
        WHERE vendor_name = ? 
          AND vendor_id = ? 
    ";

    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die("SQL prepare failed in getSalesSum: " . $conn->error . " | Query: " . $sql);
    }

    $stmt->bind_param("ss", $vendor_name, $vendor_id);
    $stmt->execute();
    $stmt->bind_result($t, $ppt, $pft);
    $stmt->fetch();
    $stmt->close();

    return [
        'total' => (float) ($t ?? 0),
        'purchase_price_total' => (float) ($ppt ?? 0),
        'profit' => (float) ($pft ?? 0)
    ];
}

// ================== STEP 1: Generate Vendor Data by Store ==================
$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username   = "iveposadmin";
$password   = "Intuition123";
$licenseDB  = "ivepos_license_retail";

$mainConn = new mysqli($servername, $username, $password, $licenseDB);
if ($mainConn->connect_error) {
    echo json_encode(['status' => 'failed', 'message' => 'Main DB connection failed']);
    exit;
}

$storeSummary = [];

$sql = "SELECT * FROM company WHERE id = '10899'";
$result = $mainConn->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $companyid = $row["id"];
        $company   = strtolower($row["company"]);

        $sql1 = "SELECT * FROM store WHERE companyid = '" . $mainConn->real_escape_string($companyid) . "'";
        $result1 = $mainConn->query($sql1);

        if ($result1 && $result1->num_rows > 0) {
            while ($row1 = $result1->fetch_assoc()) {
                $storeid = $row1["id"];
                $store   = strtolower($row1["store"]);

                if (!isset($storeSummary[$storeid])) {
                    $storeSummary[$storeid] = [
                        'store_id' => $storeid,
                        'store'    => $store,
                        'vendors'  => []
                    ];
                }

                // Temporary vendor aggregator
                $vendorTotals = [];

                $sql2 = "SELECT * FROM device WHERE storeid = '" . $mainConn->real_escape_string($storeid) . "'";
                $result2 = $mainConn->query($sql2);

                if ($result2 && $result2->num_rows > 0) {
                    while ($row2 = $result2->fetch_assoc()) {
                        $device = strtolower($row2["device"]);
                        $dbname = preg_replace('/[^a-z0-9_]/', '', $company . "_" . $store . "_" . $device . "_mydbsalesdata");

                        $conn = new mysqli($servername, $username, $password, $dbname);
                        if ($conn->connect_error) continue;

                        // First fetch distinct vendors
                        $sql = "SELECT DISTINCT vendor_name, vendor_id 
                                FROM All_Sales 
                                WHERE vendor_name != ''";
                        $result3 = $conn->query($sql);

                        if ($result3 && $result3->num_rows > 0) {
                            while ($row3 = $result3->fetch_assoc()) {
                                $vendorKey = $row3['vendor_id'];

                                // Get sums using your custom logic
                                $sums = getSalesSum($conn, $row3['vendor_name'], $row3['vendor_id']);

                                if (!isset($vendorTotals[$vendorKey])) {
                                    $vendorTotals[$vendorKey] = [
                                        'vendor_name'          => $row3['vendor_name'],
                                        'vendor_id'            => $row3['vendor_id'],
                                        'total'                => $sums['total'],
                                        'purchase_price_total' => $sums['purchase_price_total'],
                                        'profit'               => $sums['profit']
                                    ];
                                } else {
                                    $vendorTotals[$vendorKey]['total'] += $sums['total'];
                                    $vendorTotals[$vendorKey]['purchase_price_total'] += $sums['purchase_price_total'];
                                    $vendorTotals[$vendorKey]['profit'] += $sums['profit'];
                                }
                            }
                        }
                        $conn->close();
                    }
                }

                // Save aggregated vendors
                $storeSummary[$storeid]['vendors'] = array_values($vendorTotals);
            }
        }
    }
}

$mainConn->close();

// Final JSON data
$outputData = json_encode(array_values($storeSummary), JSON_PRETTY_PRINT);

// ================== STEP 2: Build HTML Table ==================
$bodyHtml = "<h3>IVEPOS Vendor Summary Report</h3>";

foreach ($storeSummary as $store) {
    $bodyHtml .= "<h4>Store: " . htmlspecialchars($store['store']) . "</h4>";
    $bodyHtml .= "<table border='1' cellspacing='0' cellpadding='6' style='border-collapse: collapse; font-family: Arial; font-size: 13px; width:100%;'>
        <tr style='background-color:#f2f2f2;'>
            <th>Vendor Name</th>
            <th>Total</th>
            <th>Purchase Price Total</th>
            <th>Profit</th>
        </tr>";

    $grandTotal = $grandPPT = $grandProfit = 0;

    foreach ($store['vendors'] as $vendor) {
        $bodyHtml .= "<tr>
            <td>" . htmlspecialchars($vendor['vendor_name']) . "</td>
            <td align='right'>" . number_format($vendor['total'], 2) . "</td>
            <td align='right'>" . number_format($vendor['purchase_price_total'], 2) . "</td>
            <td align='right'>" . number_format($vendor['profit'], 2) . "</td>
        </tr>";

        $grandTotal += $vendor['total'];
        $grandPPT   += $vendor['purchase_price_total'];
        $grandProfit+= $vendor['profit'];
    }

    // Add grand total row
    $bodyHtml .= "<tr style='font-weight:bold; background:#e6ffe6;'>
        <td>Grand Total</td>
        <td align='right'>" . number_format($grandTotal, 2) . "</td>
        <td align='right'>" . number_format($grandPPT, 2) . "</td>
        <td align='right'>" . number_format($grandProfit, 2) . "</td>
    </tr>";

    $bodyHtml .= "</table><br>";
}

// ================== STEP 3: Send Email with PHPMailer ==================
$email_to = "rajaswaminathan2109@gmail.com"; // change recipient

$sender     = 'contact@ivepos.com';
$senderName = 'Intuition';
$recipient  = $email_to;

$host = 'email-smtp.ap-south-1.amazonaws.com';
$port = 587;

$usernameSmtp = 'AKIAQ3XWIYFDRUDCRESS';
$passwordSmtp = 'BABPtIVWd8QxrCiYjq453v2XrpD+JENyiL20nil5IOML';

$subject  = 'IVEPOS Vendor Summary Report';
$bodyText = "Your IVEPOS Vendor Summary Report is attached.";

$mail = new PHPMailer(true);

try {
    $mail->isSMTP();
    $mail->setFrom($sender, $senderName);
    $mail->Username   = $usernameSmtp;
    $mail->Password   = $passwordSmtp;
    $mail->Host       = $host;
    $mail->Port       = $port;
    $mail->SMTPAuth   = true;
    $mail->SMTPSecure = 'tls';

    $mail->addAddress($recipient);
    $mail->isHTML(true);
    $mail->Subject = $subject;
    $mail->Body    = $bodyHtml;
    $mail->AltBody = $bodyText;

    // Attach JSON summary
   // $mail->addStringAttachment($outputData, "vendor_summary.json", "base64", "application/json");

    $mail->Send();
    echo json_encode(["status" => "Success", "msg" => "Email sent with vendor summary"]);
} catch (phpmailerException $e) {
    echo json_encode(["status" => "Failed", "msg" => $e->errorMessage()]);
} catch (Exception $e) {
    echo json_encode(["status" => "Failed", "msg" => $mail->ErrorInfo]);
}
