<?php
// Database configuration
// Database connection details
$host = getenv('DB_HOST') ?: 'ivepos-db-production.mysql.database.azure.com';
$username = getenv('DB_USER') ?: 'iveposadmin';
$password = getenv('DB_PASS') ?: 'Intuition123';
$dbname = getenv('DB_NAME') ?: 'ivepos_license';

// Create a database connection
$conn = new mysqli($host, $username, $password, $dbname);

// Check the connection
if ($conn->connect_error) {
    die(json_encode([
        "status" => "error",
        "message" => "Database connection failed: " . $conn->connect_error
    ]));
}

header('Content-Type: application/json');

try {
    // SQL query
    $sql = "SELECT `id`, `TranID` FROM `mswipe_webhook_data_temp` WHERE `ref_id` = ''";
    //$sql = "SELECT `id`, `TranID` FROM `mswipe_webhook_data_temp` WHERE `id` = '11347'";
    // Execute the query
    $result = $conn->query($sql);

    // Check for results
    if ($result->num_rows > 0) {
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }

        // Return data as JSON
        echo json_encode([
            "status" => "success",
            "data" => $data
        ]);
    } else {
        // No data found
        echo json_encode([
            "status" => "success",
            "data" => [],
            "message" => "No records found."
        ]);
    }
} catch (Exception $e) {
    // Handle exceptions
    echo json_encode([
        "status" => "error",
        "message" => "An error occurred: " . $e->getMessage()
    ]);
} finally {
    // Close the database connection
    $conn->close();
}
?>
