<?php

/**
 * Copyright 2010-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * This file is licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License. A copy of
 * the License is located at
 *
 * http://aws.amazon.com/apache2.0/
 *
 * This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 *  ABOUT THIS PHP SAMPLE: This sample is part of the SDK for PHP Developer Guide topic
 *
 *
 */
require 'vendor/autoload.php';

use Aws\Sns\SnsClient;
use Aws\Exception\AwsException;

/**
 * Sends a a text message (SMS message) directly to a phone number using Amazon SNS.
 *
 * This code expects that you have AWS credentials set up per:
 * https://docs.aws.amazon.com/sdk-for-php/v3/developer-guide/guide_credentials.html
 */

// Input validation and sanitization
$phonenumber = isset($_POST["username"]) ? filter_var($_POST["username"], FILTER_SANITIZE_STRING) : null;
$otp = isset($_POST["iveposOtp"]) ? filter_var($_POST["iveposOtp"], FILTER_SANITIZE_STRING) : null;

// Validate phone number and OTP
if (empty($phonenumber) || empty($otp)) {
    error_log("Phone number or OTP is missing.");
    $response = new \stdClass();
    $response->status = "failed";
    $response->message = "Phone number or OTP is missing.";
    echo json_encode($response);
    exit;
}

// AWS credentials - consider using environment variables or a more secure method
$params = array(
    'credentials' => array(
        'key' => getenv('AWS_ACCESS_KEY_ID') ?: 'AKIAQ3XWIYFD5UXDLO56', // Use environment variables
        'secret' => getenv('AWS_SECRET_ACCESS_KEY') ?: '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' // Use environment variables
    ),
    'region' => 'ap-south-1',
    'version' => 'latest'
);

echo "otp :".getenv('AWS_ACCESS_KEY_ID');

$sns = new Aws\Sns\SnsClient($params);

$message = 'Your IVEPOS/Intuition OTP for secure login is : ' . $otp . '';

$args = array(
    'Message' => $message,
    'PhoneNumber' => $phonenumber,

);

try {
    
    $blockedCodes = ['+880', '+964', '+20','+93'];

    if (isBlockedNumber($phonenumber, $blockedCodes)) {
        // Do nothing or handle appropriately (e.g., log this case)
    } else {
        $result = $sns->publish($args);

        $response = new \stdClass();
        $response->status = "success";
        $response->message = $result;
        echo json_encode($response);
    }

} catch (AwsException $e) {
    // output error message if fails
    error_log($e->getMessage());
    $response = new \stdClass();
    $response->status = "failed";
    $response->message = $e->getMessage();
    echo json_encode($response);

}

// Database connection
$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$dbname = "ivepos_support";

$username_alt = $phonenumber;

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Use prepared statements to prevent SQL injection
$sql = "SELECT * FROM `signin_otp_log` WHERE `username`=?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username_alt);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {

    $sql = "UPDATE `signin_otp_log` SET `otp`=? WHERE `username`= ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $otp, $username_alt);


    if ($stmt->execute() === TRUE) {
        // echo "Record Updated successfully";
    } else {
        error_log("Error updating record: " . $conn->error); // Log the error
    }

} else {

    $sql = "INSERT INTO `signin_otp_log` (`username`, `otp`) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $username_alt, $otp);
    if ($stmt->execute() === TRUE) {
        //echo "New record created successfully";
    } else {
        error_log("Error creating record: " . $conn->error); // Log the error
    }
}

$conn->close(); // Close the connection



// Function to check if phone number starts with any blocked code
function isBlockedNumber($phonenumber, $blockedCodes) {
    foreach ($blockedCodes as $code) {
        if (strpos($phonenumber, $code) === 0) {
            return true;
        }
    }
    return false;
}
?>