<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$logFile = __DIR__ . "/../otp_debug.log";

/* ---------------- LOG REQUEST ---------------- */
$callingService = "unknown";

if (getenv('AWS_LAMBDA_FUNCTION_NAME')) {
    $callingService = "Lambda";
} elseif (@file_get_contents(
    'http://169.254.169.254/latest/meta-data/instance-id',
    false,
    stream_context_create(['http' => ['timeout' => 0.1]])
)) {
    $callingService = "EC2";
} elseif (!empty($_SERVER['HTTP_X_AMZ_COGNITO_IDENTITY'])) {
    $callingService = "Cognito";
}

$callingScript = $_SERVER['HTTP_X_CALLING_SCRIPT'] 
    ?? ($_SERVER['SCRIPT_FILENAME'] ?? 'unknown');

$logEntry = [
    "timestamp"       => date("Y-m-d H:i:s"),
    "full_path"       => realpath(__FILE__),
    "source_ip"       => $_SERVER['REMOTE_ADDR'] ?? 'unknown',
    "forwarded_for"   => $_SERVER['HTTP_X_FORWARDED_FOR'] ?? 'none',
    "referer"         => $_SERVER['HTTP_REFERER'] ?? 'none',
    "user_agent"      => $_SERVER['HTTP_USER_AGENT'] ?? 'none',
    "request_method"  => $_SERVER['REQUEST_METHOD'] ?? 'none',
    "query_string"    => $_SERVER['QUERY_STRING'] ?? 'none',
    "post_data"       => $_POST ?: [],
    "calling_service" => $callingService,
    "calling_script"  => $callingScript
];

file_put_contents($logFile, json_encode($logEntry) . PHP_EOL, FILE_APPEND);

/* ---------------- AUTOLOAD ---------------- */
require __DIR__ . '/../vendor/autoload.php';
use Twilio\Rest\Client;

/* ---------------- INPUT VALIDATION ---------------- */
$phonenumber = $_POST["username"] ?? null;
$otp         = $_POST["iveposOtp"] ?? null;

if (!$phonenumber || !$otp) {
    echo json_encode([
        "status" => "failed",
        "error"  => "Phone number and OTP is missing"
    ]);
    exit;
}

/* ---------------- BLOCKED COUNTRY CODES ---------------- */
$blockedCodes = ['+880', '+964', '+20', '+93'];
if (isBlockedNumber($phonenumber, $blockedCodes)) {
    echo json_encode([
        "status" => "failed",
        "error"  => "Blocked phone number"
    ]);
    exit;
}

/* ---------------- BLOCKED NUMBERS ---------------- */
$blockedNumbers = ['+919581497872'];
if (in_array($phonenumber, $blockedNumbers)) {
    echo json_encode([
        "status" => "failed",
        "error"  => "This number is blocked from receiving OTPs."
    ]);
    exit;
}

/* ---------------- SEND OTP USING TWILIO ---------------- */
try {
    $twilio = new Client(
        getenv('TWILIO_SID'),
        getenv('TWILIO_AUTH_TOKEN')
    );

    $message = $twilio->messages->create(
        $phonenumber,
        [
            "from" => getenv('TWILIO_FROM'),
            "body" => "Your IVEPOS/Intuition OTP for secure login is : $otp"
        ]
    );

} catch (Exception $e) {
    error_log("Twilio Error: " . $e->getMessage());
    echo json_encode([
        "status" => "failed",
        "error"  => "OTP delivery failed"
    ]);
    exit;
}

/* ---------------- DATABASE ---------------- */
$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$dbUsername = "iveposadmin";
$dbPassword = "Intuition123";
$dbname     = "ivepos_support";

$conn = new mysqli($servername, $dbUsername, $dbPassword, $dbname);
if ($conn->connect_error) {
    error_log("DB connection failed: " . $conn->connect_error);
    exit;
}

$stmt = $conn->prepare("SELECT * FROM signin_otp_log WHERE username=?");
$stmt->bind_param("s", $phonenumber);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $stmt = $conn->prepare(
        "UPDATE signin_otp_log SET otp=? WHERE username=?"
    );
    $stmt->bind_param("ss", $otp, $phonenumber);
} else {
    $stmt = $conn->prepare(
        "INSERT INTO signin_otp_log (username, otp) VALUES (?, ?)"
    );
    $stmt->bind_param("ss", $phonenumber, $otp);
}
$stmt->execute();
$conn->close();

/* ---------------- SUCCESS RESPONSE ---------------- */
echo json_encode([
    "status"      => "success",
    "provider"    => "twilio",
    "sid"         => $message->sid,
    "phoneNumber" => $phonenumber
]);

/* ---------------- FUNCTIONS ---------------- */
function isBlockedNumber($phonenumber, $blockedCodes) {
    foreach ($blockedCodes as $code) {
        if (strpos($phonenumber, $code) === 0) {
            return true;
        }
    }
    return false;
}
?>
