<?php
$current_timestamp = date("Y-m-d H:i:s");
// Set headers
header("Content-Type: application/json");
ini_set('log_errors', 1);
error_reporting(E_ALL);

// Database connection details
$host = getenv('DB_HOST') ?: 'ivepos-db-production-regular.mysql.database.azure.com';
$username = getenv('DB_USER') ?: 'iveposadmin';
$password = getenv('DB_PASS') ?: 'Intuition123';
$dbname = getenv('DB_NAME') ?: 'ivepos_license';

// Create connection
$conn = new mysqli($host, $username, $password, $dbname);
if ($conn->connect_error) {
    error_log("Database connection failed: " . $conn->connect_error);
    respond("error", "Database connection failed", 500);
}

// Read input
$input = file_get_contents('php://input');
$data = json_decode($input, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    respond("error", "Invalid JSON payload", 400);
}

// Extract values from input
$CardNumber = $data['CardNumber'] ?? null;
$RRN = $data['RRN'] ?? null;
$AuthID = $data['AuthID'] ?? null;
$RC = $data['RC'] ?? null;
$DateTime = $data['DateTime'] ?? null;
$TranID = $data['TranID'] ?? null;
$MerID = $data['MerID'] ?? null;
$TermID = $data['TermID'] ?? null;
$TranType = $data['TranType'] ?? null;
$CardType = $data['CardType'] ?? null;
$CustMobNr = $data['CustMobNr'] ?? null;
$CardProduct = $data['CardProduct'] ?? null;
$TranAmount = $data['TranAmount'] ?? null;
$InvNo = $data['InvNo'] ?? null;
$ME_NAME = $data['ME_NAME'] ?? null;
$ME_CITY = $data['ME_CITY'] ?? null;
$TRAN_STATUS = $data['TRAN_STATUS'] ?? null;
$STAN = $data['STAN'] ?? null;
$NOTES = $data['NOTES'] ?? null;
$card_holder_name = $data['card_holder_name'] ?? null;
$RC_DESC = $data['RC_DESC'] ?? null;
$WP_ID = $data['WP_ID'] ?? null;
$EX_NOTES = $data['EX_NOTES'] ?? null;
$custname = $data['custname'] ?? null;
$custcode = $data['custcode'] ?? null;
$payervpa = $data['payervpa'] ?? null;
$payeevpa = $data['payeevpa'] ?? null;
$amount = $data['amount'] ?? null;
$mid = $data['mid'] ?? null;
$tid = $data['tid'] ?? null;
$trxid = $data['trxid'] ?? null;
$ref_id = $data['ref_id'] ?? null;

// Create the SQL query (be cautious of SQL injection here)
$sql = "INSERT INTO mswipe_webhook_data (
    CardNumber, RRN, AuthID, RC, DateTime1, TranID, MerID, TermID, TranType, CardType, 
    CustMobNr, CardProduct, TranAmount, InvNo, ME_NAME, ME_CITY, TRAN_STATUS, STAN, 
    NOTES, card_holder_name, RC_DESC, WP_ID, EX_NOTES, custname, custcode, payervpa, 
    payeevpa, amount, mid, tid, trxid, ref_id,json_data
) VALUES (
    '$CardNumber', '$RRN', '$AuthID', '$RC', '$DateTime', '$TranID', '$MerID', '$TermID', 
    '$TranType', '$CardType', '$CustMobNr', '$CardProduct', '$TranAmount', '$InvNo', 
    '$ME_NAME', '$ME_CITY', '$TRAN_STATUS', '$STAN', '$NOTES', '$card_holder_name', 
    '$RC_DESC', '$WP_ID', '$EX_NOTES', '$custname', '$custcode', '$payervpa', '$payeevpa', 
    '$amount', '$mid', '$tid', '$trxid', '$ref_id','$input'
)";

// Execute the query
if ($conn->query($sql) === TRUE) {
    respond("success", "Data inserted successfully", 200,$current_timestamp);
} else {
    error_log("Insert failed: " . $conn->error);
    respond("error", "Failed to insert data", 500,$current_timestamp);
}

// Close connection
$conn->close();

// Utility function for responses
function respond($status, $message, $code,$time2) {
    http_response_code($code);
    echo json_encode(["status" => $status, "message" => $message,"api_hit_timestamp" => $current_timestamp]);
    exit;
}
?>
