<?php
set_time_limit(0); // Allows infinite execution time
ini_set('memory_limit', '1024M'); // Increases memory usage limit

$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";

// Source and target DB config
$source_config = [
    'host' => 'ivepos-db-production-regular.mysql.database.azure.com',
    'user' => 'iveposadmin',
    'password' => 'Intuition123',
    'port' => 3306
];

$target_config = [
    'host' => 'ivepos-db-production.mysql.database.azure.com',
    'user' => 'iveposadmin',
    'password' => 'Intuition123',
    'port' => 3306
];

// Collect POST values
$companyId = "10883";
//$_POST['companyId'];
$type = "retail";//$_POST['type'];

// Connect to license DB
if ($type == 'restaurant') {
    $conn = new mysqli($servername, $username, $password, "ivepos_license");
} else {
    $conn = new mysqli($servername, $username, $password, "ivepos_license_retail");
}

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Collect databases
$databases_to_migrate = [];

$sql = "SELECT `company` FROM company WHERE id='$companyId'";
$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $company = $row['company'];

    $store_count_sql = "SELECT store, id FROM store WHERE companyid='$companyId'";
    $store_count_result = $conn->query($store_count_sql);
    while ($store_row = $store_count_result->fetch_assoc()) {
        $store_id = $store_row['id'];
        $store_name = $store_row['store'];

        $device_count_sql = "SELECT device, id FROM device WHERE storeid='$store_id'";
        $device_count_result = $conn->query($device_count_sql);
        while ($device_row = $device_count_result->fetch_assoc()) {
            $device_name = $device_row['device'];
            $appdb = "{$company}_{$store_name}_{$device_name}_mydbappdata";
            $salesdb = "{$company}_{$store_name}_{$device_name}_mydbsalesdata";
            $databases_to_migrate[] = $appdb;
            $databases_to_migrate[] = $salesdb;
        }
    }
}

// Paths
$mysqldump_path = 'C:\Bitnami\wampstack-7.0.30-2\mysql\bin\mysqldump.exe';
$mysql_path = 'C:\Bitnami\wampstack-7.0.30-2\mysql\bin\mysql.exe';

// Dump and import one database
function dump_and_import_database($source_config, $target_config, $db_name) {
    global $mysqldump_path, $mysql_path;

    $temp_file = "C:\\Bitnami\\wampstack-7.0.30-2\\apache2\\htdocs\\IVEPOS\\dumps\\dump_{$db_name}.sql";

    // Force-disable SSL for both dump and import
    $dump_cmd = "\"$mysqldump_path\" -h {$source_config['host']} -u {$source_config['user']} -p{$source_config['password']} --port={$source_config['port']} --no-create-db --single-transaction --quick --ssl-mode=DISABLED $db_name --result-file=\"$temp_file\"";
    $import_cmd = "\"$mysql_path\" -h {$target_config['host']} -u {$target_config['user']} -p{$target_config['password']} --port={$target_config['port']} --ssl-mode=DISABLED $db_name < \"$temp_file\"";

    echo "Migrating $db_name...\n";

    exec($dump_cmd, $dump_output, $dump_result);
    if ($dump_result !== 0) {
        echo "❌ Error dumping $db_name. Code: $dump_result\n";
        echo "Dump command:\n$dump_cmd\n";
        echo "Dump output:\n" . implode("\n", $dump_output) . "\n";
        return false;
    }

    exec($import_cmd, $import_output, $import_result);
    if ($import_result !== 0) {
        echo "❌ Error importing $db_name. Code: $import_result\n";
        echo "Import command:\n$import_cmd\n";
        echo "Import output:\n" . implode("\n", $import_output) . "\n";

        // Optional: show start of the file
        $preview = file_exists($temp_file) ? file_get_contents($temp_file, false, null, 0, 200) : "File not found.";
        echo "Preview of dump file:\n$preview\n";
        return false;
    }

    echo "✅ Success: $db_name migrated.\n";
    return true;
}

// Loop all databases
function migrate_selected_databases($source_config, $target_config, $databases) {
    global $mysql_path;

    // Disable SSL at PHP level too
    $target_conn = mysqli_init();
    mysqli_real_connect(
        $target_conn,
        $target_config['host'],
        $target_config['user'],
        $target_config['password'],
        '',
        $target_config['port'],
        null,
        MYSQLI_CLIENT_SSL_DONT_VERIFY_SERVER_CERT
    );

    if (mysqli_connect_errno()) {
        die("❌ Connection failed (Target DB): " . mysqli_connect_error());
    }

    $target_conn->query("CREATE DATABASE IF NOT EXISTS `migrated_databases`");
    $target_conn->query("USE `migrated_databases`");
    $target_conn->query("CREATE TABLE IF NOT EXISTS databases_list (db_name VARCHAR(255) PRIMARY KEY)");

    $migrated_count = 0;

    foreach ($databases as $db_name) {
        echo "🔄 Checking: $db_name\n";

        $result = $target_conn->query("SELECT db_name FROM databases_list WHERE db_name = '$db_name'");
        if ($result && $result->num_rows > 0) {
            echo "⚠️ Skipping already migrated: $db_name\n";
            continue;
        }

        $target_conn->query("CREATE DATABASE IF NOT EXISTS `$db_name`");

        if (dump_and_import_database($source_config, $target_config, $db_name)) {
            $target_conn->query("INSERT INTO databases_list (db_name) VALUES ('$db_name')");
            $migrated_count++;
        }
    }

    echo "✅ Done. Total migrated: $migrated_count\n";
    $target_conn->close();
}

// Start migration
if (!empty($databases_to_migrate)) {
    migrate_selected_databases($source_config, $target_config, $databases_to_migrate);
} else {
    echo "No databases found to migrate. Company ID: $companyId | Type: $type\n";
}
?>
