<?php
$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$dbname_input = preg_replace('/[^a-zA-Z0-9_]/', '', $_POST['db_name']);
$dbname = $dbname_input . "_mydbsalesdata";

// Connect
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed', 'sql_error' => $conn->connect_error]);
    exit;
}

// Inputs
$table_id = $conn->real_escape_string($_POST['table_id'] ?? '');
$provided_bill_number = $conn->real_escape_string($_POST['bill_number'] ?? '');

if (empty($table_id) || empty($provided_bill_number)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid or missing table_id or bill_number']);
    exit;
}

// Fetch KOT entries for the table
$kot_query = "SELECT * FROM kot_temp WHERE table_id = '$table_id'";
$kot_result = $conn->query($kot_query);
if (!$kot_result || $kot_result->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['error' => 'No KOTs found for this table']);
    exit;
}

// Merge KOT data
$merged = [];
$total_fields = ['total', 'subtotal', 'taxtotal', 'roundoff', 'globaltaxtotal', 'delivery_fee', 'packing_charges', 'loyalty_points', 'loyalty_amount'];

while ($row = $kot_result->fetch_assoc()) {
    foreach ($row as $key => $value) {
        if (in_array($key, ['table_id', 'mobile_no','customer_name','status','_id'])) {
            continue; // skip these keys
        }

        if (in_array($key, $total_fields)) {
            $merged[$key] = ($merged[$key] ?? 0) + floatval($value);
        } else {
            if (!isset($merged[$key]) || $merged[$key] === '') {
                $merged[$key] = $value;
            }
        }
    }
}

$merged['printed'] = 'yes';
$merged['billnumber'] = $provided_bill_number;

// Insert into `billnumber` table
$fields = array_keys($merged);
$values = array_map([$conn, 'real_escape_string'], array_values($merged));
$field_str = '`' . implode('`,`', $fields) . '`';
$value_str = "'" . implode("','", $values) . "'";

$insert_bill = "INSERT INTO billnumber ($field_str) VALUES ($value_str)";
if (!$conn->query($insert_bill)) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to insert merged bill into billnumber', 'sql_error' => $conn->error]);
    exit;
}

// Fetch KOT items for this table
$item_query = "SELECT * FROM kot_items_temp WHERE table_id = '$table_id'";
$item_result = $conn->query($item_query);
if (!$item_result || $item_result->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['error' => 'No KOT items found for this table']);
    exit;
}

// Insert KOT items into `all_sales` with updated bill number
while ($item = $item_result->fetch_assoc()) {
    unset($item['_id']);
    $item['bill_no'] = $provided_bill_number; // Overwrite with provided bill number

    $item_fields = array_keys($item);
    $item_values = array_map([$conn, 'real_escape_string'], array_values($item));
    $item_field_str = '`' . implode('`,`', $item_fields) . '`';
    $item_value_str = "'" . implode("','", $item_values) . "'";

    $insert_item = "INSERT INTO all_sales ($item_field_str) VALUES ($item_value_str)";
    if (!$conn->query($insert_item)) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to insert item into all_sales', 'sql_error' => $conn->error]);
        exit;
    }
}

// Delete original KOT data
$delete_kot = "DELETE FROM kot_temp WHERE table_id = '$table_id'";
$delete_items = "DELETE FROM kot_items_temp WHERE table_id = '$table_id'";

$delete_kot_res = $conn->query($delete_kot);
$delete_items_res = $conn->query($delete_items);

if (!$delete_kot_res || !$delete_items_res) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Bill created, but failed to delete original KOT data',
        'sql_error' => $conn->error
    ]);
    exit;
}

// ✅ Success
echo json_encode([
    'success' => true,
    'message' => 'Bill generated and KOT data cleared successfully',
    'bill_number' => $provided_bill_number
]);

$conn->close();
?>
