﻿<?php
$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$dbname_input = preg_replace('/[^a-zA-Z0-9_]/', '', $_POST['db_name']);
$dbname = $dbname_input . "_mydbsalesdata";

// Connect
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed', 'sql_error' => $conn->connect_error]);
    exit;
}

// Inputs
$table_id = $conn->real_escape_string($_POST['table_id'] ?? '');
$user = $conn->real_escape_string($_POST['user'] ?? '');
$provided_bill_number = $conn->real_escape_string($_POST['bill_number'] ?? '');

if (empty($table_id) || empty($provided_bill_number)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid or missing table_id or bill_number']);
    exit;
}

// Fetch KOT entries for the table and user
$kot_query = "SELECT * FROM kot_temp WHERE table_id = '$table_id' AND customer_name = '$user'";
$kot_result = $conn->query($kot_query);
if (!$kot_result || $kot_result->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['error' => 'No KOTs found for this table and user', 'query' => $kot_query]);
    exit;
}

// Prepare for merging
$merged = [];
$kot_ids = [];
$total_fields = ['total', 'subtotal', 'taxtotal', 'roundoff', 'globaltaxtotal', 'delivery_fee', 'packing_charges', 'loyalty_points', 'loyalty_amount'];

while ($row = $kot_result->fetch_assoc()) {
    $kot_ids[] = $row['billnumber'];

    foreach ($row as $key => $value) {
        if (in_array($key, ['table_id', 'mobile_no', 'customer_name', 'status', '_id'])) {
            continue;
        }

        if (in_array($key, $total_fields)) {
            $merged[$key] = ($merged[$key] ?? 0) + floatval($value);
        } else {
            if (!isset($merged[$key]) || $merged[$key] === '') {
                $merged[$key] = $value;
            }
        }
    }
}

$merged['printed'] = 'yes';
$merged['billnumber'] = $provided_bill_number;

// Insert into `billnumber`
$fields = array_keys($merged);
$values = array_map([$conn, 'real_escape_string'], array_values($merged));
$field_str = '`' . implode('`,`', $fields) . '`';
$value_str = "'" . implode("','", $values) . "'";

$insert_bill = "INSERT INTO billnumber ($field_str) VALUES ($value_str)";
if (!$conn->query($insert_bill)) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to insert merged bill into billnumber', 'sql_error' => $conn->error]);
    exit;
}

// Insert KOT items to `all_sales` where kot_id in transferred list
if (!empty($kot_ids)) {
    // ✅ FIXED: Properly handle string bill numbers
    $in_clause = implode(",", array_map(function($bill) use ($conn) {
        return "'" . $conn->real_escape_string($bill) . "'";
    }, $kot_ids));

    $item_query = "SELECT * FROM kot_items_temp WHERE bill_no IN ($in_clause)";
    $item_result = $conn->query($item_query);

    if (!$item_result || $item_result->num_rows === 0) {
        http_response_code(404);
        echo json_encode(['error' => 'No KOT items found for this bill']);
        exit;
    }

    while ($item = $item_result->fetch_assoc()) {
        unset($item['_id']);
        $item['bill_no'] = $provided_bill_number;

        $item_fields = array_keys($item);
        $item_values = array_map([$conn, 'real_escape_string'], array_values($item));
        $item_field_str = '`' . implode('`,`', $item_fields) . '`';
        $item_value_str = "'" . implode("','", $item_values) . "'";

        $insert_item = "INSERT INTO all_sales ($item_field_str) VALUES ($item_value_str)";
        if (!$conn->query($insert_item)) {
            http_response_code(500);
            echo json_encode(['error' => 'Failed to insert item into all_sales', 'sql_error' => $conn->error]);
            exit;
        }
    }

    // Delete only the transferred KOT data
    $delete_kot = "DELETE FROM kot_temp WHERE billnumber IN ($in_clause)";
    $delete_items = "DELETE FROM kot_items_temp WHERE bill_no IN ($in_clause)";

    $delete_kot_res = $conn->query($delete_kot);
    $delete_items_res = $conn->query($delete_items);

    if (!$delete_kot_res || !$delete_items_res) {
        http_response_code(500);
        echo json_encode([
            'error' => 'Bill created, but failed to delete original KOT data',
            'sql_error' => $conn->error
        ]);
        exit;
    }
}

// ✅ Success response
echo json_encode([
    'success' => true,
    'message' => 'Bill generated and relevant KOT data cleared successfully',
    'bill_number' => $provided_bill_number
]);

$conn->close();
?>
