<?php
$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$dbname_input = preg_replace('/[^a-zA-Z0-9_]/', '', $_POST['db_name']);
$dbname = $dbname_input . "_mydbsalesdata";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

// Fetch all KOTs
$kot_temp = [];
$table_map = [];

$res1 = $conn->query("SELECT * FROM kot_temp where `status` != 'Canceled'");
while ($row = $res1->fetch_assoc()) {
    $row['items'] = []; // prepare items array

    $kot_temp[$row['_id']] = $row;

    $table_id = $row['table_id'];
    $customer_name = $row['customer_name'];

    if (!isset($table_map[$table_id])) {
        $table_map[$table_id] = [
            'table_id' => $table_id,
            'customers' => []
        ];
    }

    if (!isset($table_map[$table_id]['customers'][$customer_name])) {
        $table_map[$table_id]['customers'][$customer_name] = [
            'customer_name' => $customer_name,
            'bills' => []
        ];
    }

    $table_map[$table_id]['customers'][$customer_name]['bills'][] = &$kot_temp[$row['_id']];
}

// Fetch KOT items
$res2 = $conn->query("SELECT * FROM kot_items_temp");
while ($item = $res2->fetch_assoc()) {
    foreach ($kot_temp as &$kot) {
        if ($kot['billnumber'] == $item['bill_no']) {
            $kot['items'][] = $item;
            break;
        }
    }
}

// Prepare final structured output
$output = [];
foreach ($table_map as $table) {
    $customers = [];
    foreach ($table['customers'] as $customer) {
        $customers[] = $customer;
    }
    $output[] = [
        'table_id' => $table['table_id'],
        'customers' => $customers
    ];
}

// Output JSON
header('Content-Type: application/json');
echo json_encode($output);
$conn->close();
?>
