<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$dbname_ivepos_license = "ivepos_license";
$dbname_ivepos_license_retail = "ivepos_license_retail";

$filterData = $_POST['filterData'];

$filterWhere_text = "AND c.status = 'purchased'";
if($filterData == 'Overall'){
$filterWhere_text = "";
}

$project_type = $_POST['project_type'] ?? '';

try {
    $conn1 = new mysqli($servername, $username, $password, $dbname_ivepos_license);
    $conn2 = new mysqli($servername, $username, $password, $dbname_ivepos_license_retail);

    if ($conn1->connect_error || $conn2->connect_error) {
        throw new Exception("Database connection failed: " . $conn1->connect_error . " | " . $conn2->connect_error);
    }

    $sql = "SELECT c.id, c.company, c.email,c.phone_number,c.lead_type,c.description , COUNT(d.id) AS active_licenses_count
            FROM company c
            INNER JOIN device d ON c.id = d.companyid
            WHERE d.expirydate > NOW() $filterWhere_text
            GROUP BY c.id, c.company, c.email";

    $result1 = $conn1->query($sql);
    $result2 = $conn2->query($sql);

    if ($result1 === false || $result2 === false) {
        throw new Exception("Query execution failed");
    }

    $active_companies = array();

    while ($row1 = $result1->fetch_assoc()) {
        $row1['business_type'] ="Dine";
        $active_companies[] = $row1;
    }

    while ($row2 = $result2->fetch_assoc()) {
        $row2['business_type'] ="Retail";
        $active_companies[] = $row2;
    }

    $data = [
        "status" => "success",
        "message" => "",
        "records" => $active_companies
    ];

} catch (Exception $e) {
    $data = [
        "status" => "failed",
        "message" => $e->getMessage()
    ];
}

header('Content-Type: application/json');
echo json_encode($data, JSON_PRETTY_PRINT);

if ($conn1) {
    $conn1->close();
}
if ($conn2) {
    $conn2->close();
}
?>
