<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$combinedRecords = [];

function getMonthlySales($conn, $company, $store_id, $store_name, $device_id, $device_name) {
    global $servername, $username, $password;
    $monthlySales = [];
    $monthlyBillCounts = [];
    $monthlyActive = [];
    $new_db_name = $company . "_" . $store_name . "_" . $device_name . "_mydbsalesdata";
    $new_db_conn = new mysqli($servername, $username, $password, $new_db_name);
    if ($new_db_conn->connect_error) {
        return ["sales" => $monthlySales, "bill_counts" => $monthlyBillCounts, "active" => $monthlyActive];
    }
    $years = [2023, 2024, 2025];
    $months = [
        '01' => 'jan', '02' => 'feb', '03' => 'mar', '04' => 'apr',
        '05' => 'may', '06' => 'jun', '07' => 'jul', '08' => 'aug',
        '09' => 'sep', '10' => 'oct', '11' => 'nov', '12' => 'dec'
    ];
    // $years = [2025];
    // $months = [
    //     '05' => 'may', '06' => 'jun', '07' => 'jul'
    // ];
    foreach ($years as $year) {
        foreach ($months as $mnum => $mname) {
            $start = $year . $mnum . '010001';
            $end = $year . $mnum . date('t', strtotime($year.'-'.$mnum.'-01')) . '2359';
            $sales_sql = "SELECT SUM(total) as total,COUNT(total) as bill_count1 FROM billnumber WHERE datetimee_new >= '$start' AND datetimee_new <= '$end'";
            $sales_result = $new_db_conn->query($sales_sql);
            $total = 0;
            $bill_count1 = 0;
            if ($sales_result && $sales_row = $sales_result->fetch_assoc()) {
                $total = floatval($sales_row['total']);
                $bill_count1 = intval($sales_row['bill_count1']);
            }
            $monthlySales[$year][$mname] = $total;
            $monthlyBillCounts[$year][$mname] = $bill_count1;
            $monthlyActive[$year][$mname] = ($total > 0) ? 1 : 0;
        }
    }
    $new_db_conn->close();
    return ["sales" => $monthlySales, "bill_counts" => $monthlyBillCounts, "active" => $monthlyActive];
}

function retrieveOverallMonthlySales($conn) {
    $overallMonthlySales = [];
    $overallMonthlyBillCounts = [];
    $overallMonthlyActive = [];
    $sql = "SELECT id, company FROM company";
    $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $company = $row['company'];
            $companyid = $row['id'];
            $store_count_sql = "SELECT store, id FROM store WHERE companyid='$companyid'";
            $store_count_result = $conn->query($store_count_sql);
            while ($store_row = $store_count_result->fetch_assoc()) {
                $store_id = $store_row['id'];
                $store_name = $store_row['store'];
                $device_count_sql = "SELECT device, id,expirydate FROM device WHERE storeid='$store_id'";
                $device_count_result = $conn->query($device_count_sql);
                while ($device_row = $device_count_result->fetch_assoc()) {
                    $device_id = $device_row['id'];
                    $device_name = $device_row['device'];
                    $expirydate = strtotime($device_row['expirydate']);
                    //if ($expirydate > time()) {
                        $monthlyData = getMonthlySales($conn, $company, $store_id, $store_name, $device_id, $device_name);
                        $monthlySales = $monthlyData["sales"];
                        $monthlyBillCounts = $monthlyData["bill_counts"];
                        $monthlyActive = $monthlyData["active"];
                        foreach ($monthlySales as $year => $months) {
                            foreach ($months as $mname => $total) {
                                if (!isset($overallMonthlySales[$year][$mname])) {
                                    $overallMonthlySales[$year][$mname] = 0;
                                }
                                $overallMonthlySales[$year][$mname] += $total;
                            }
                        }
                        foreach ($monthlyBillCounts as $year => $months) {
                            foreach ($months as $mname => $count) {
                                if (!isset($overallMonthlyBillCounts[$year][$mname])) {
                                    $overallMonthlyBillCounts[$year][$mname] = 0;
                                }
                                $overallMonthlyBillCounts[$year][$mname] += $count;
                            }
                        }
                        foreach ($monthlyActive as $year => $months) {
                            foreach ($months as $mname => $isActive) {
                                if (!isset($overallMonthlyActive[$year][$mname])) {
                                    $overallMonthlyActive[$year][$mname] = 0;
                                }
                                $overallMonthlyActive[$year][$mname] += $isActive;
                            }
                        }
                   // }
                }
            }
        }
    }
    return ["sales" => $overallMonthlySales, "bill_counts" => $overallMonthlyBillCounts, "active_customers" => $overallMonthlyActive];
}




// $conn_license = new mysqli($servername, $username, $password, "ivepos_license");
$conn_license_retail = new mysqli($servername, $username, $password, "ivepos_license_retail");

if ($conn_license_retail->connect_error) {
    die("Connection failed: " . $conn_license->connect_error . " | " . $conn_license_retail->connect_error);
}

// Get sales and bill counts for both license types
// $overallMonthlyData1 = retrieveOverallMonthlySales($conn_license);
$overallMonthlyData2 = retrieveOverallMonthlySales($conn_license_retail);


$overallMonthlySales = [];
$overallMonthlyBillCounts = [];
$overallMonthlyActiveCustomers = [];
foreach ([2023, 2024, 2025] as $year) {
    foreach (["jan","feb","mar","apr","may","jun","jul","aug","sep","oct","nov","dec"] as $mname) {
        $overallMonthlySales[$year][$mname] = 0;
        $overallMonthlyBillCounts[$year][$mname] = 0;
        $overallMonthlyActiveCustomers[$year][$mname] = 0;
        // if (isset($overallMonthlyData1["sales"][$year][$mname])) {
        //     $overallMonthlySales[$year][$mname] += $overallMonthlyData1["sales"][$year][$mname];
        // }
        if (isset($overallMonthlyData2["sales"][$year][$mname])) {
            $overallMonthlySales[$year][$mname] += $overallMonthlyData2["sales"][$year][$mname];
        }
        // if (isset($overallMonthlyData1["bill_counts"][$year][$mname])) {
        //     $overallMonthlyBillCounts[$year][$mname] += $overallMonthlyData1["bill_counts"][$year][$mname];
        // }
        if (isset($overallMonthlyData2["bill_counts"][$year][$mname])) {
            $overallMonthlyBillCounts[$year][$mname] += $overallMonthlyData2["bill_counts"][$year][$mname];
        }
        // if (isset($overallMonthlyData1["active_customers"][$year][$mname])) {
        //     $overallMonthlyActiveCustomers[$year][$mname] += $overallMonthlyData1["active_customers"][$year][$mname];
        // }
        if (isset($overallMonthlyData2["active_customers"][$year][$mname])) {
            $overallMonthlyActiveCustomers[$year][$mname] += $overallMonthlyData2["active_customers"][$year][$mname];
        }
    }
}

// $conn_license->close();
$conn_license_retail->close();



$data = [
    "status" => "success",
    "message" => "",
    "sales" => $overallMonthlySales,
    "bill_counts" => $overallMonthlyBillCounts,
    "active_customers" => $overallMonthlyActiveCustomers
];

header('Content-Type: application/json');
echo json_encode($data, JSON_PRETTY_PRINT);
?>
