<?php
// api/get_printer_assignments.php

$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$defaultDbname = "your_default_db"; // Replace with a valid default database name

// Enable CORS (for development - adjust as needed for production)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit;
}

try {
    // Get the db_name from the query parameters
    $dbname = isset($_GET['db_name']) ? $_GET['db_name'] : $defaultDbname;

    // Attempt database connection
    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        http_response_code(500);
        echo json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]);
        exit;
    }

    // Fetch printer assignments
    $sql = "SELECT type, printer FROM web_printer";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $results = array();
        while($row = $result->fetch_assoc()) {
            $results[] = $row;
        }
        echo json_encode($results);
    } else {
        echo json_encode([]); // Return empty array if no results
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to fetch printer assignments: ' . $e->getMessage()]);
} finally {
    if ($conn) {
        $conn->close();
    }
}
?>