<?php
// api/printer_assignments.php
header('Content-Type: application/json');

// Enable error reporting (Remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Enable CORS (Adjust for production)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database credentials (Move to a secure location)
$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$defaultDbname = "your_default_db"; // Replace with a valid database

// Validate and sanitize dbname
$dbname = isset($_POST['dbname']) ? trim($_POST['dbname']) : $defaultDbname;
if (empty($dbname)) {
    echo json_encode(["error" => "Database name is required."]);
    exit;
}

// Create database connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    echo json_encode(["error" => "Connection failed: " . $conn->connect_error]);
    exit;
}

$data = [];

// Step 1: Fetch all unprinted KOTs
$billQuery = "SELECT * FROM `billnumber` WHERE printed = 'No'";
$billResult = $conn->query($billQuery);

if ($billResult) {
    while ($billRow = $billResult->fetch_assoc()) {
        $billnumber = $conn->real_escape_string($billRow['billnumber']); // Prevent SQL Injection
        
        // Step 2: Fetch items for this KOT
        $itemQuery = "SELECT * FROM `all_sales` WHERE bill_no ='$billnumber'";
        $itemResult = $conn->query($itemQuery);

        $items = [];
        if ($itemResult) {
            while ($itemRow = $itemResult->fetch_assoc()) {
                $items[] = $itemRow;
            }
        }

        // Step 3: Append the KOT and its items to the data array
        $data[] = [
            "billDetails" => $billRow,
            "items" => $items
        ];
    }
} else {
    echo json_encode(["error" => "Error fetching KOTs: " . $conn->error]);
    exit;
}

//echo json_encode(["error" => "Error fetching KOTs: " . $dbname]);

// Return JSON response
echo json_encode($data, JSON_PRETTY_PRINT);

$conn->close();
?>
