<?php
// api/printer_assignments.php
header('Content-Type: application/json');

// Enable error reporting (Remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Enable CORS (Adjust for production)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database credentials (Move to a secure location)
$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$defaultDbname = "your_default_db"; // Replace with a valid database

// Validate and sanitize dbname
$dbname = isset($_POST['dbname']) ? trim($_POST['dbname']) : $defaultDbname;
if (empty($dbname)) {
    echo json_encode(["error" => "Database name is required."]);
    exit;
}

// Create database connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    echo json_encode(["error" => "Connection failed: " . $conn->connect_error]);
    exit;
}

$data = [];

// Step 1: Fetch all unprinted KOTs
$kotQuery = "SELECT _id, billnumber, table_id FROM kot_temp WHERE printed = 'No'";
$kotResult = $conn->query($kotQuery);

if ($kotResult) {
    while ($kotRow = $kotResult->fetch_assoc()) {
        $kot_no = $conn->real_escape_string($kotRow['billnumber']); // Prevent SQL Injection
        $table_id = $kotRow['table_id'];
        $ref_id = $kotRow['_id'];

        // Step 2: Fetch items for this KOT
        $itemQuery = "SELECT itemname, quantity, user, price FROM kot_items_temp WHERE TRIM(bill_no) = TRIM('$kot_no')";

        $itemResult = $conn->query($itemQuery);

if (!$itemResult) {
    error_log("Item query failed for KOT $kot_no: " . $conn->error);
}

        $items = [];
        if ($itemResult) {
            while ($itemRow = $itemResult->fetch_assoc()) {
                $itemRow['total'] = $itemRow['quantity'] * $itemRow['price']; // Calculate total
                $items[] = $itemRow;
            }
        }

        // Step 3: Append the KOT and its items to the data array
        $data[] = [
            "ref_id" => $ref_id,
            "kot_no" => $kot_no,
            "table_id" => $table_id,
            "items" => $items
		
        ];
    }
} else {
    echo json_encode(["error" => "Error fetching KOTs: " . $conn->error]);
    exit;
}

// Return JSON response
echo json_encode($data, JSON_PRETTY_PRINT);

$conn->close();
?>
