<?php
header('Content-Type: application/json');

// Enable error reporting (Remove in production)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Enable CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("Content-Length: 0");
    http_response_code(204);
    exit;
}

// Secure Database Connection (Move credentials to a secure location)
$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$defaultDbname = "your_default_db";

// Validate and sanitize dbname
$dbname = isset($_POST['dbname']) ? trim($_POST['dbname']) : $defaultDbname;
if (empty($dbname)) {
    echo json_encode(["error" => "Database name is required."]);
    exit;
}

// Create database connection
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    echo json_encode(["error" => "Connection failed: " . $conn->connect_error]);
    exit;
}

// Read KOT ID from POST
if (!isset($_POST['kot_id'])) {
    echo json_encode(["error" => "Invalid or missing KOT ID."]);
    exit;
}

$kotId = $_POST['kot_id'];

// Prepare query using prepared statement
$stmt = $conn->prepare("UPDATE kot_temp SET printed = 'Yes' WHERE billnumber = ?");
$stmt->bind_param("s", $kotId);

if ($stmt->execute()) {
    echo json_encode(["success" => "KOT status updated successfully.", "kot_id" => $kotId]);
} else {
    echo json_encode(["error" => "Error updating KOT status: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
