<?php 
// api/printer_assignments.php
header('Content-Type: application/json');

// Enable error reporting (Remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Enable CORS (Adjust for production)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database credentials (Move to a secure location)
$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$defaultDbname = "your_default_db"; // Replace with a valid database

// Validate and sanitize dbname
$dbname = isset($_POST['dbname']) ? trim($_POST['dbname']) : $defaultDbname;
if (empty($dbname)) {
    echo json_encode(["error" => "Database name is required."]);
    exit;
}

// Create database connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    echo json_encode(["error" => "Connection failed: " . $conn->connect_error]);
    exit;
}

// Fetch company logo
$logoQuery = "SELECT companylogo FROM logo";
$logoResult = $conn->query($logoQuery);

$response = [];
if ($logoResult && $logoRow = $logoResult->fetch_assoc()) {
    $logoData = $logoRow['companylogo'] ?? null;
    if ($logoData) {
        $response["company_logo"] = $logoData;
    } else {
        $response["error"] = "No logo found.";
    }
} else {
    $response["error"] = "Error fetching company logo: " . $conn->error;
}

// Return JSON response
echo json_encode($response, JSON_PRETTY_PRINT);

$conn->close();
?>
