<?php
// api/printer_assignments.php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$defaultDbname = "your_default_db"; // Replace with a valid default database name

// Enable CORS (for development - adjust as needed for production)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit;
}

try {
    // Get the JSON data from the request body
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);

    // Validate the data
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!isset($data['assignment_name']) || !isset($data['printer_name']) || !isset($data['business_type']) || !isset($data['db_name'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing assignment_name, printer_name, business_type, or db_name']);
        exit;
    }
}

    $assignmentName = $data['assignment_name'];
    $printerName = $data['printer_name'];
    $businessType = $data['business_type'];
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $dbname = $data['db_name'];
}
else{
 $dbname = $GET['db_name'];
}

    // Attempt database connection
    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        http_response_code(500);
        echo json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]);
        exit;
    }

    // Get all printer assignments
    if ($_SERVER['REQUEST_METHOD'] == 'GET') {
        try {
            $sql = "SELECT type, printer FROM web_printer";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                $results = array();
                while($row = $result->fetch_assoc()) {
                    $results[] = $row;
                }
                echo json_encode($results);
            } else {
                echo json_encode([]); // Return empty array if no results
            }
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => 'Failed to fetch printer assignments: ' . $e->getMessage()]);
        }
        exit;
    }

    // Create or update a printer assignment
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        try {
            // Check if the assignment already exists
            $sql = "SELECT COUNT(*) FROM web_printer WHERE type = '$assignmentName'";
            $result = $conn->query($sql);
            $row = $result->fetch_row();
            $count = $row[0];

            if ($count > 0) {
                // Update the existing assignment
                $sql = "UPDATE web_printer SET printer = '$printerName' WHERE type = '$assignmentName'";
                 if ($conn->query($sql) === TRUE) {
                    http_response_code(200);
                    echo json_encode(['message' => 'Printer assignment updated successfully: ' . $printerName]);
                } else {
                    http_response_code(500);
                    echo json_encode(['error' => 'Failed to update printer assignment: ' . $conn->error]);
                }
            } else {
                // Insert a new assignment
                $sql = "INSERT INTO web_printer (printer, device_id, type) VALUES ('$printerName', '', '$assignmentName')";

                if ($conn->query($sql) === TRUE) {
                    http_response_code(200);
                    echo json_encode(['message' => 'Printer assignment saved successfully: ' . $printerName]);
                } else {
                    http_response_code(500);
                    echo json_encode(['error' => 'Failed to save printer assignment: ' . $conn->error]);
                }
            }



        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => 'Failed to save printer assignment: ' . $e->getMessage()]);
        }
        exit;
    }

    // If the request method is not supported
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;

} finally {
    if ($conn) {
        $conn->close();
    }
}
?>