<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$config = require 'config.php'; // loads DB info

$mysqli = new mysqli(
    $config['db_host'],
    $config['db_user'],
    $config['db_pass'],
    $config['db_name'],
    $config['db_port']
);

if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Get input
$username = $_POST['username'] ?? null;
$password = $_POST['password'] ?? null;
$phone    = $_POST['phoneNumber'] ?? null;

if (!$username || !$password || !$phone) {
    echo json_encode(["error" => "Missing fields"]);
    exit;
}

// Cleanup expired tokens
$mysqli->query("DELETE FROM tokens WHERE expiry < NOW()");

// fetch stored hex
$stmt = $mysqli->prepare("SELECT password FROM users WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$stmt->bind_result($storedHex);
$stmt->fetch();
$stmt->close();

if (!$storedHex) {
    echo json_encode(['ok'=>false,'error'=>'invalid username']);
    exit;
}

// helper: base64url decode (handles padding)
function base64url_decode($data) {
    $data = strtr($data, '-_', '+/');
    $pad = strlen($data) % 4;
    if ($pad) $data .= str_repeat('=', 4 - $pad);
    return base64_decode($data);
}

$encData = base64url_decode($password);
$ivLen = openssl_cipher_iv_length('AES-256-CBC');

if (strlen($encData) < $ivLen + 32) {
    echo json_encode(['ok'=>false,'error'=>'payload too short','len'=>strlen($encData),'expected_min'=>($ivLen+32)]);
    exit;
}

$iv = substr($encData, 0, $ivLen);
$hmac = substr($encData, $ivLen, 32);
$ciphertext = substr($encData, $ivLen + 32);

// calculate hmac
$calcHmac = hash_hmac('sha256', $iv . $ciphertext, $config['secret_hmac'], true);
$hmac_ok = hash_equals($hmac, $calcHmac);

// try decrypt
$decrypted = openssl_decrypt($ciphertext, 'AES-256-CBC', $config['secret_key'], OPENSSL_RAW_DATA, $iv);
$decrypted_hex = $decrypted === false ? null : bin2hex($decrypted);

// stored hex (from DB) is string
$stored_hex = $storedHex;
$stored_bin = hex2bin($stored_hex);

// compare (binary-safe)
$match = ($decrypted !== false && hash_equals($decrypted, $stored_bin));

if (!hash_equals($decrypted, hex2bin($stored_hex))) {
    echo json_encode(["error" => "Invalid username/password"]);
    exit;
}

// Build token payload
$expiry = time() + 120; // validity
$payload = $phone . "|" . $expiry;

// Encrypt with AES-256-CBC
$iv = random_bytes(openssl_cipher_iv_length("AES-256-CBC"));
$ciphertext = openssl_encrypt($payload, "AES-256-CBC", $config['secret_key'], OPENSSL_RAW_DATA, $iv);

// Add HMAC
$hmac = hash_hmac("sha256", $iv . $ciphertext, $config['secret_hmac'], true);

// Build final token
$token = rtrim(strtr(base64_encode($iv . $hmac . $ciphertext), '+/', '-_'), '=');




// Save in DB (for tracking/cleanup)
date_default_timezone_set("Asia/Kolkata");
$expiry_date = date("Y-m-d H:i:s", $expiry);
$stmt = $mysqli->prepare("INSERT INTO tokens (phone, token, expiry) VALUES (?, ?, ?)");
if (!$stmt) {
    die("Prepare failed: " . $mysqli->error);
}
$stmt->bind_param("sss", $phone, $token, $expiry_date);
$stmt->execute();
$stmt->close();

echo json_encode([
    "phone" => $phone,
    "auth_token" => $token,
    "expires_at" => $expiry_date
]);
?>
