<?php
require __DIR__ . '/vendor/autoload.php';


use Aws\Sns\SnsClient;
use Aws\Exception\AwsException;

/**
 * Fetch AWS secret from Azure Function
 */
function get_aws_secret($secret_name) {
    $function_url = "https://ec2accesskeyvault-gpfzamg4dab4dndd.centralindia-01.azurewebsites.net/api/getsecret?secret=$secret_name&code=gB2aiQ0glIVkfvpHcy7mX-TL0J2JxHqwuCSHN-0CDMMDAzFuETwIKg==";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $function_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $secret_value = curl_exec($ch);

    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code !== 200) {
        throw new Exception("Azure Function returned HTTP $http_code for secret $secret_name");
    }

    if (!$secret_value || trim($secret_value) === "") {
        throw new Exception("Empty secret value returned for: $secret_name");
    }

    return trim($secret_value);
}

/**
 * Return SNS client with credentials from Azure Function
 */
function get_sns_client($region = 'ap-south-1') {
    $aws_access_key = get_aws_secret("AWS-ACCESS-KEY");
    $aws_secret_key = get_aws_secret("AWS-SECRET-KEY");

    return new SnsClient([
        'credentials' => [
            'key'    => $aws_access_key,
            'secret' => $aws_secret_key
        ],
        'region'  => $region,
        'version' => 'latest'
    ]);
}
