<?php
$post = json_decode(file_get_contents('php://input'));

$company = $post->company ?? '';
$store   = $post->store ?? '';
$device  = $post->device ?? '';

$dbname = $company . '_' . $store . '_' . $device . '_mydbsalesdata';

// Add timestamp to filename
$timestamp = date('Ymd_His');
$dumpDir   = "C:\\Bitnami\\wampstack-8.0.3-2\\apache2\\htdocs\\IVEPOS\\IVEPOS_AZURE\\dumps\\";
$outputFile = $dumpDir . "file_{$dbname}.sql";

// Use MySQL 8 client path
$mysqldumpPath = "\"C:\\Program Files\\MySQL\\MySQL Server 8.0\\bin\\mysqldump.exe\"";

// Build command (SSL disabled)
$command = $mysqldumpPath . " "
         . "-h ivepos-db-production-regular.mysql.database.azure.com "
         . "-u iveposadmin "
         . "-pIntuition123 "
         . "--ssl-mode=DISABLED "
         . "--no-create-info --complete-insert --compact "
         . $dbname;

$descriptorspec = [
    0 => ["pipe", "r"],
    1 => ["pipe", "w"],
    2 => ["pipe", "w"]
];

$process = proc_open($command, $descriptorspec, $pipes);

$myObj = new \stdClass();

if (is_resource($process)) {
    $stdout = stream_get_contents($pipes[1]);
    $stderr = stream_get_contents($pipes[2]);
    fclose($pipes[1]);
    fclose($pipes[2]);

    $return_var = proc_close($process);

    if ($return_var === 0) {
        file_put_contents($outputFile, $stdout);
        $myObj->status = "success";
        $myObj->file   = $outputFile;
    } else {
        $myObj->status  = "error";
        $myObj->message = trim($stderr ?: $stdout);
        // Mask password in command for safety
        $maskedCommand = str_replace("Intuition123", "****", $command);
        $myObj->command = $maskedCommand;
    }
} else {
    $myObj->status  = "error";
    $myObj->message = "Failed to start mysqldump process";
    $maskedCommand = str_replace("Intuition123", "****", $command);
    $myObj->command = $maskedCommand;
}

// Return JSON
echo json_encode($myObj, JSON_PRETTY_PRINT);
?>
