<?php

$post = json_decode(file_get_contents('php://input'));

if (!isset($post->company) || !isset($post->store) || !isset($post->device)) {
    $errorObj = new \stdClass();
    $errorObj->status = "error";
    $errorObj->message = "Invalid input";
    echo json_encode($errorObj);
    exit();
}

$company = escapeshellarg($post->company);
$store = escapeshellarg($post->store);
$device = escapeshellarg($post->device);

$sourceDbHost = 'ivepos-db-production-regular.mysql.database.azure.com';
$sourceDbUser = 'iveposadmin';
$sourceDbPass = 'Intuition123';
$mysqldumpPath = 'C:\\Bitnami\\wampstack-7.0.30-2\\mysql\\bin\\mysqldump.exe';
$mysqlPath = 'C:\\Bitnami\\wampstack-7.0.30-2\\mysql\\bin\\mysql.exe';
$dumpPath = 'C:\\Bitnami\\wampstack-7.0.30-2\\apache2\\htdocs\\IVEPOS\\dumps';
$database = "{$company}_{$store}_{$device}_mydbappdata";

// Dump structure command
$structureDumpFile = "{$dumpPath}\\structure_{$database}.sql";
$dumpStructureCommand = "$mysqldumpPath -h $sourceDbHost -u $sourceDbUser -p$sourceDbPass --no-data --compact $database > $structureDumpFile";
exec($dumpStructureCommand, $outputStructureDump, $statusStructureDump);

// Log the structure dump command and output
file_put_contents('structure_dump_log.txt', "Structure Dump Command: $dumpStructureCommand\nOutput: " . print_r($outputStructureDump, true) . "\nStatus: $statusStructureDump\n");

// Dump data command
$dataDumpFile = "{$dumpPath}\\data_{$database}.sql";
$dumpDataCommand = "$mysqldumpPath -h $sourceDbHost -u $sourceDbUser -p$sourceDbPass --no-create-info --complete-insert --compact $database > $dataDumpFile";
exec($dumpDataCommand, $outputDataDump, $statusDataDump);

// Log the data dump command and output
file_put_contents('data_dump_log.txt', "Data Dump Command: $dumpDataCommand\nOutput: " . print_r($outputDataDump, true) . "\nStatus: $statusDataDump\n");

$targetDbHost = '3.7.51.83';
$targetDbUser = 'admin';
$targetDbPass = 'iveposadmin';
$targetDatabase = "{$company}_{$store}_{$device}_mydbappdata";

// Create database command
$createDbCommand = "$mysqlPath -h $targetDbHost -u $targetDbUser -p$targetDbPass --ssl-mode=DISABLED -e \"CREATE DATABASE IF NOT EXISTS $targetDatabase\"";
exec($createDbCommand . ' 2>&1', $outputCreateDb, $statusCreateDb);

// Log the create database command and output
file_put_contents('create_db_log.txt', "Create DB Command: $createDbCommand\nOutput: " . print_r($outputCreateDb, true) . "\nStatus: $statusCreateDb\n");

// Import structure command
$importStructureCommand = "$mysqlPath -h $targetDbHost -u $targetDbUser -p$targetDbPass --ssl-mode=DISABLED $targetDatabase < $structureDumpFile";
exec($importStructureCommand . ' 2>&1', $outputImportStructure, $statusImportStructure);

// Log the import structure command and output
file_put_contents('import_structure_log.txt', "Import Structure Command: $importStructureCommand\nOutput: " . print_r($outputImportStructure, true) . "\nStatus: $statusImportStructure\n");

// Import data command
$importDataCommand = "$mysqlPath -h $targetDbHost -u $targetDbUser -p$targetDbPass --ssl-mode=DISABLED $targetDatabase < $dataDumpFile";
exec($importDataCommand . ' 2>&1', $outputImportData, $statusImportData);

// Log the import data command and output
file_put_contents('import_data_log.txt', "Import Data Command: $importDataCommand\nOutput: " . print_r($outputImportData, true) . "\nStatus: $statusImportData\n");

$response = new \stdClass();
if ($statusStructureDump === 0 && $statusDataDump === 0 && $statusCreateDb === 0 && $statusImportStructure === 0 && $statusImportData === 0) {
    $response->status = "success";
} else {
    $response->status = "error";
    $response->message = "Failed to execute mysqldump, create database, or import";
    $response->details = [
        'structure_dump_status' => $statusStructureDump,
        'structure_dump_output' => $outputStructureDump,
        'data_dump_status' => $statusDataDump,
        'data_dump_output' => $outputDataDump,
        'create_db_status' => $statusCreateDb,
        'create_db_output' => $outputCreateDb,
        'import_structure_status' => $statusImportStructure,
        'import_structure_output' => $outputImportStructure,
        'import_data_status' => $statusImportData,
        'import_data_output' => $outputImportData
    ];
}

echo json_encode($response);

?>
